﻿Public Class Form1
    ' Składowe.
    Public AddressBook As AddressBook
    Private _currentAddressIndex As Integer

    'Właściwość CurrentAddress - właściwość zwracająca aktualny adres.
    ReadOnly Property CurrentAddress() As Address
        Get
            Return AddressBook.Items(CurrentAddressIndex - 1)
        End Get
    End Property

    'Właściwość CurrentAddressIndex - właściwość reprezentująca indeks aktualnego adresu.
    Property CurrentAddressIndex() As Integer
        Get
            Return _currentAddressIndex
        End Get
        Set(ByVal Value As Integer)
            'Ustawianie adresu.
            _currentAddressIndex = Value
            'Aktualizacja wyświetlanych danych.
            PopulateFormFromAddress(CurrentAddress)
            'Ustawianie etykiety.
            lblAddressNumber.Text = _
            _currentAddressIndex & " z " & AddressBook.Items.Count
        End Set
    End Property

    Private Sub Form1_Load(ByVal sender As System.Object, _
            ByVal e As System.EventArgs) Handles MyBase.Load
        'Wczytywanie książki adresowej.
        AddressBook = _
           SerializableData.Load(DataFilename, GetType(AddressBook))
        'Jeśli książka nie zawiera elementów, należy dodać nowy element.
        If AddressBook.Items.Count = 0 Then AddressBook.AddAddress()
        'Wybranie pierwszego elementu listy.
        CurrentAddressIndex = 1
    End Sub

    Private Sub Form1_FormClosed(ByVal sender As Object, ByVal e As  _
        System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        'Zapisanie zmian.
        UpdateCurrentAddress()
        SaveChanges()
    End Sub

    'Metoda SaveChanges - zapisanie książki adresowej do pliku XML.
    Public Sub SaveChanges()
        'Polecenie zapisania książki adresowej.
        AddressBook.Save(DataFilename)
    End Sub
    'Metoda UpdateCurrentAddress - upewnienie się, że książka zawiera 
    'aktualne wartości wpisane w formularzu.
    Private Sub UpdateCurrentAddress()
        PopulateAddressFromForm(CurrentAddress)
    End Sub

    Private Sub btnSave_Click(ByVal sender As System.Object, _
         ByVal e As System.EventArgs) Handles btnSave.Click
        'Tworzenie nowego obiektu Address.
        Dim address As New Address()
        'Kopiowanie do obiektu wartości z formularza.
        PopulateAddressFromForm(address)
        'Zapisanie obiektu.
        Dim filename As String = DataFilename
        address.Save(filename)
        'Wyświetlenie informacji dla użytkownika.
        MsgBox("Dane zostały zapisane do pliku " & filename)
    End Sub

    'Właściwość DataFilename - określa miejsce zapisu danych.
    Public ReadOnly Property DataFilename() As String
        Get
            'Pobranie bieżącego katalogu.
            Dim folder As String
            folder = Environment.CurrentDirectory
            'Zwraca nazwę katalogu wraz z nazwą pliku, "Addressbook.xml".
            Return folder & "\AddressBook.xml"
        End Get
    End Property

    'Metoda PopulateAddressFromForm - zapełnia obiekt Address wartościami pól formularza.
    Public Sub PopulateAddressFromForm(ByVal address As Address)
        'Kopiowanie wartości.
        address.FirstName = txtFirstName.Text
        address.LastName = txtLastName.Text
        address.CompanyName = txtCompanyName.Text
        address.Address1 = txtAddress1.Text
        address.Address2 = txtAddress2.Text
        address.City = txtCity.Text
        address.Region = txtRegion.Text
        address.PostalCode = txtPostalCode.Text
        address.Country = txtCountry.Text
        address.Email = txtEmail.Text
    End Sub

    Private Sub btnLoad_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLoad.Click
        'Wczytywanie danych adresowych za pomocą współdzielonej 
        'metody obiektu SerializableData.
        Dim newAddress As Address = _
           SerializableData.Load(DataFilename, GetType(Address))
        'Aktualizacja wyświetlanych danych.
        PopulateFormFromAddress(newAddress)

    End Sub

    'Metoda PopulateFormFromAddress - zapełnia formularz danymi z
    'obiektu Address.
    Public Sub PopulateFormFromAddress(ByVal address As Address)
        'Kopiowanie wartości.
        txtFirstName.Text = address.FirstName
        txtLastName.Text = address.LastName
        txtCompanyName.Text = address.CompanyName
        txtAddress1.Text = address.Address1
        txtAddress2.Text = address.Address2
        txtCity.Text = address.City
        txtRegion.Text = address.Region
        txtPostalCode.Text = address.PostalCode
        txtCountry.Text = address.Country
        txtEmail.Text = address.Email
    End Sub

    Private Sub lnkSendEmail_LinkClicked(ByVal sender As System.Object, _
      ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) _
      Handles lnkSendEmail.LinkClicked
        'Uruchomienie klienta poczty elektronicznej.
        System.Diagnostics.Process.Start("mailto:" & txtEmail.Text)
    End Sub

    Private Sub btnNew_Click(ByVal sender As System.Object, _
            ByVal e As System.EventArgs) Handles btnNew.Click
        AddNewAddress()
    End Sub

    Public Function AddNewAddress() As Address
        'Zapisanie aktualnego adresu.
        UpdateCurrentAddress()

        'Utworzenie nowego adresu.
        Dim newAddress As Address = AddressBook.AddAddress
        'Aktualizacja wyświetlanych danych.
        CurrentAddressIndex = AddressBook.Items.Count
        'Zwrócenie nowego adresu.
        Return newAddress
    End Function

    Private Sub btnNext_Click(ByVal sender As System.Object, _
     ByVal e As System.EventArgs) Handles btnNext.Click
        MoveNext()
    End Sub

    Public Sub MoveNext()
        'Pobranie następnego indeksu.
        Dim newIndex As Integer = CurrentAddressIndex + 1
        If newIndex > AddressBook.Items.Count Then
            newIndex = 1
        End If
        'Zapisanie zmian.
        UpdateCurrentAddress()
        'Zmiana aktualnego indeksu.
        CurrentAddressIndex = newIndex
    End Sub

    Private Sub btnPrevious_Click(ByVal sender As System.Object, _
     ByVal e As System.EventArgs) Handles btnPrevious.Click
        MovePrevious()
    End Sub

    Public Sub MovePrevious()
        'Pobranie indeksu poprzedniego rekordu.
        Dim newIndex As Integer = CurrentAddressIndex - 1
        If newIndex = 0 Then
            newIndex = AddressBook.Items.Count
        End If
        'Zapisanie zmian.
        UpdateCurrentAddress()
        'Zmiana aktualnego indeksu.
        CurrentAddressIndex = newIndex
    End Sub

    Private Sub btnDelete_Click(ByVal sender As System.Object, _
            ByVal e As System.EventArgs) Handles btnDelete.Click
           'Prośba o potwierdzenie polecenia usunięcia.
        If MsgBox("Czy na pewno chcesz usunąć ten adres?", _
            MsgBoxStyle.Question Or MsgBoxStyle.YesNo) = _
            MsgBoxResult.Yes Then
            DeleteAddress(CurrentAddressIndex)
        End If
    End Sub

    'Metoda DeleteAddress - usuwa adres z listy.
    Public Sub DeleteAddress(ByVal index As Integer)
        'Usuwanie elementu z listy.
        AddressBook.Items.RemoveAt(index - 1)
        'Czy był to jedyny adres?
        If AddressBook.Items.Count = 0 Then
            'Dodawanie nowego adresu.
            AddressBook.AddAddress()
        Else
            'Upewnienie się, że indeks wskazuje na poprawny element.
            If index > AddressBook.Items.Count Then
                index = AddressBook.Items.Count
            End If
        End If
        'Wyświetlanie rekordu.
        CurrentAddressIndex = index
    End Sub

End Class
